/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
/// ' Microsoft Content Management Server - Sample Code 
/// '
/// ' This sample code is provided "AS IS" with no warranties, and confers no rights. 
/// ' You assume all risk for your use.  2002 Microsoft Corporation. All rights reserved.
/// '
/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	
using System;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Web.UI.HtmlControls;
using System.Drawing;
//Array reference for array of channels
using System.Collections;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
//Add reference to the CMS API
using Microsoft.ContentManagement.Publishing;


namespace McmsSpsWebControlLibrary
{
	/// <summary>
	/// 
	/// 
	/// Summary description for GlobalNavigationControl.
	/// 
	/// This control is designed to show a high level navigation bar in the the site header.
	/// The links correspond to subchannels under the base channel.
	/// </summary>
	[Designer(typeof(McmsSpsWebControlLibrary.Design.McmsGlobalNavigationDesigner)),
	ToolboxBitmapAttribute(typeof(McmsGlobalNavigationControl), "MCMSToolBoxImage.bmp"),
	ToolboxData("<{0}:McmsGlobalNavigationControl runat=server></{0}:McmsGlobalNavigationControl>")]
	public class McmsGlobalNavigationControl : System.Web.UI.WebControls.WebControl, INamingContainer
	{
		#region Public constructors
		public McmsGlobalNavigationControl(): base()
		{	
			linkTarget = "_self";
			startChannel = "Channels";
			
			string SeparatorString = " :: ";
			// Write a line to the Listener
			System.Diagnostics.Trace.WriteLine(System.DateTime.Now + SeparatorString + "Control" + SeparatorString + "Global Navigation Control" + SeparatorString + "This is the constructor for the Global Navigation Control.");
			// Record your output
			System.Diagnostics.Trace.Flush();
		}

		#endregion Public constructors

		#region Private member variables
		private string text;
		//User defined properties 
		private string designText;
		private string cssClass;
		private string selectedCssClass;
		private string separator;
		private string startChannel;
		private string linkTarget;
		private Channel objBaseChannel = null;

		//Select list for channel name format
		public enum enumChannelNameOptions{Name, DisplayName};
		private enumChannelNameOptions enumChannelName;
		#endregion Private member variables

		#region Properties
		/// <summary>
		///		Default text property.
		/// </summary>
		/// 
		[Bindable(true), 
			Category("Appearance"), 
			DefaultValue("")] 
		public string Text 
		{
			get
			{
				return text;
			}

			set
			{
				text = value;
			}
		}

		/// <summary>
		///		The text that appears in the control in design view.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Text that appears in design view."),
		Category("Global Navigation"),
		DefaultValue("Global Navigation")]
		public string DesignText
		{
			get { return designText; }
			set { designText = value; }
		}
		//Allow user to change the value of property - in design view
		bool ShouldSerializeDesignText(){return true;}

		/// <summary>
		///		The default CSS style class for the control - both runtime and design.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Default CSS Style for the control."),
		Category("Appearance")]
		public override string CssClass
		{
			get { return cssClass; }
			set { cssClass = value; }
		}
		//Allow user to change the value of property - in design view
		bool ShouldSerializeCssClass(){return true;}

		/// <summary>
		///		The selected CSS style class for the control - both runtime and design.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Selected CSS Style for the control."),
		Category("Appearance")]
		public string SelectedCssClass
		{
			get { return selectedCssClass; }
			set { selectedCssClass = value; }
		}
		//Allow user to change the value of property - in design view
		bool ShouldSerializeSelectedCssClass(){return true;}

		/// <summary>
		///		The Channel name ooption used in the display.
		///		Options: DisplayName, Name
		/// </summary>
		/// 		
		[Description("The Channel name type used in the control. Options are 'DisplayName' and 'Name'."),
		Category("Global Navigation"),]
		public enumChannelNameOptions ChannelName
		{
			get { return enumChannelName; }
			set { enumChannelName = value; }
		}			
		//Allow user to change the value of property - in design view
		bool ShouldSerializeChannelName(){return true;}

		/// <summary>
		///		The HTML between the Channels in the navigation.
		/// </summary>
		/// 		
		[Browsable(true),
		Description("The separator HTML used in the control."),
		Category("Global Navigation"),
		DefaultValue("|")]
		public string Separator
		{
			get { return separator; }
			set { separator = value; }
		}	
		//Allow user to change the value of property - in design view
		bool ShouldSerializeSeparator(){return true;}

		/// <summary>
		///		Start Channel property.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Start Channel"),
		Category("Navigation"),
		DefaultValue("Channels")]
		public string StartChannel 
		{
			get { return startChannel; }
			set { startChannel = value; }
		}

		//Allow user to change the value of property - in design view
		bool ShouldSerializeStartChannel(){return true;}

		/// <summary>
		///		Link Target property.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Link Target"),
		Category("Navigation"),
		DefaultValue("_self")]
		public string LinkTarget 
		{
			get { return linkTarget; }
			set { linkTarget = value; }
		}

		//Allow user to change the value of property - in design view
		bool ShouldSerializeLinkTarget(){return true;}

		#endregion Properties
		
		#region Private functions

		/// <summary>
		/// Function to populate the table control used to present data.
		/// </summary>
		private Table PopulateNavigationTable(Table table)
		{
			//Instantiate CMS AutosessionHTMLContext
			CmsHttpContext CMSContext = CmsHttpContext.Current;
			
			table.ForeColor = System.Drawing.Color.White;
			//Use the user defined style sheet class
			if(CssClass != null)
			{
				//Use the user defined style sheet class
				try
				{
					table.CssClass = CssClass;
				}
				catch
				{
					return table; //Early return
				}
			}

			System.Web.UI.WebControls.TableRow	row;
			System.Web.UI.WebControls.TableCell	cell;
			row = new System.Web.UI.WebControls.TableRow();	
			table.Rows.Add(row);			

			//Create anchor object for the links
			HtmlAnchor navLink;

			//This control shows the subchannels underneath the base channel of the site
			//Find the base channel - it will be under the root channel
			ChannelCollection colSubChannels =CMSContext.RootChannel.Channels; 
			
			if (CMSContext.RootChannel.Name.ToLower() == StartChannel.ToLower())
			{
				//If we are directly under the root level then the current channel is the base
				colSubChannels = CMSContext.RootChannel.Channels;
				objBaseChannel = CMSContext.Channel;
			}
			else
			{
				if(CMSContext.RootChannel.Channels.Count>0)
				{
					foreach(Channel hChannel in CMSContext.RootChannel.Channels)			
					{		
						if ((hChannel.Name.ToLower() == StartChannel.ToLower()) || (hChannel.DisplayName.ToLower() == StartChannel.ToLower()))
						{
							colSubChannels = hChannel.Channels;	
							objBaseChannel = hChannel;
							break;
						}
						else
						{
							if(hChannel.Channels.Count>0)
							{
								foreach(Channel subChannel in hChannel.Channels)
								{
									if ((subChannel.Name.ToLower() == StartChannel.ToLower()) || (subChannel.DisplayName.ToLower() == StartChannel.ToLower()))
									{
										colSubChannels = subChannel.Channels;	
										objBaseChannel = subChannel;
										break;
									}
									else
									{
										if(subChannel.Channels.Count>0)
										{
											foreach(Channel subChdChannel in subChannel.Channels)
											{
												if ((subChdChannel.Name.ToLower() == StartChannel.ToLower()) || (subChdChannel.DisplayName.ToLower() == StartChannel.ToLower()))
												{
													colSubChannels = subChdChannel.Channels;
													objBaseChannel = subChdChannel;
													break;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			
			//Error check for null Channel object
			if(colSubChannels == null)
			{
				return table; //Early return
			}		

			//Handle the case where the base objects is null
			if(objBaseChannel == null)	 
			{
				objBaseChannel = CMSContext.RootChannel;
			}
			
			//Prepare base Channel anchor link
			navLink = new HtmlAnchor();
			navLink.HRef = objBaseChannel.Url;
			navLink.Target = LinkTarget;
			//Change appearance of current channel
			if(objBaseChannel == CMSContext.Channel)
			{	
				navLink.InnerHtml = "<span class=selectedTopChannel>" + HttpUtility.HtmlEncode(objBaseChannel.DisplayName) + "</span>";
			}
			else
			{
				navLink.InnerHtml = "<span class=nonselectedTopChannel>" + HttpUtility.HtmlEncode(objBaseChannel.DisplayName) + "</span>";
			}
				
			// Add link to the table
			cell = new System.Web.UI.WebControls.TableCell();
			//Use user defined property for style
			cell.Wrap = false;
			cell.Controls.Add(navLink);
			row.Cells.Add(cell);
				
			//Add spacer between first link and other links
			cell = new System.Web.UI.WebControls.TableCell();
			cell.Wrap = false;
			cell.Text = Separator;
			row.Cells.Add(cell);

			if(objBaseChannel.Channels.Count>0)
			{
				//Create a link to each child Channel
				foreach (Channel pChannel in objBaseChannel.Channels)
				{
					//Get current Channel
					Channel objThisChannel = CMSContext.Channel;
					//Prepare Channel anchor link
					navLink = new HtmlAnchor();
				
					//Change appearance of current channel
					if(pChannel == objThisChannel.Parent || pChannel == objThisChannel)
					{	
						//Option to allow user to specify the style in the user control properties
						navLink.InnerHtml = "<span class=selectedTopChannel>"  + HttpUtility.HtmlEncode(pChannel.DisplayName) + "</span>";
					}
					else
					{
						navLink.InnerHtml = "<span class=nonselectedTopChannel>"  + HttpUtility.HtmlEncode(pChannel.DisplayName) + "</span>";
					}
					//Link to the Channel
					navLink.HRef = pChannel.Url;
					navLink.Target = LinkTarget;
					//Add link to the table
					cell = new System.Web.UI.WebControls.TableCell();
					cell.Wrap = false;				
					cell.Controls.Add(navLink);
					row.Cells.Add(cell);
				
					//Add user defined spacer HTML between links
					cell = new System.Web.UI.WebControls.TableCell();
					cell.Text = Separator;
					row.Cells.Add(cell);
				}
			}
			return table;

		} //Close PopulateNavigationTable

		/// <summary>
		/// Create child controls.
		/// </summary>
		protected override void CreateChildControls()
		{
			//Call base class
			base.CreateChildControls();

			// Code to create a Table
			System.Web.UI.WebControls.Table	tblNavigation = new System.Web.UI.WebControls.Table();
			//Populate Press release table
			PopulateNavigationTable(tblNavigation);
			//Add table to the Controls collection so it gets rendered
			Controls.Add(tblNavigation);
		}	//Close CreateChildControls

		/// <summary> 
		/// Render this control to the output parameter specified.
		/// </summary>
		/// <param name="output"> The HTML writer to write out to </param>
		protected override void Render(HtmlTextWriter output)
		{
			//Call base class
			base.Render(output);
			output.Write(Text);
		}
		#endregion Private functions

	}	//Close class
}  // Close namespace

//EOF - SC - Jan 2002